export interface User {
  id: string;
  username: string;
  avatar: string;
  isLoggedIn: boolean;
}

export interface POI {
  id: string;
  name: string;
  description: string;
  imageUrl: string;
  rating: number;
}

export interface Performance {
  id: string;
  name: string;
  time: string;
  location: string;
  imageUrl: string;
}

export interface Food {
  id: string;
  name: string;
  description: string;
  imageUrl: string;
  rating: number;
}

export interface Travelogue {
  id: string;
  userId: string;
  userName: string;
  userAvatar: string;
  title: string;
  content: string;
  images: string[];
  likes: number;
  date: string;
  type?: 'post' | 'album' | 'video'; // New field for content type
  videoUrl?: string; // New field for video
}

export interface ScenicArea {
  id: string;
  name: string;
  shortDesc: string;
  fullDesc: string;
  coverImage: string;
  pois: POI[];
  performances?: Performance[]; // New field
  foods?: Food[]; // New field
  travelogues: Travelogue[];
  album: string[];
  location: string;
  tags: string[];
}

export interface ChatMessage {
  id: string;
  role: 'user' | 'model';
  text: string;
  timestamp: Date;
}

export enum AppRoute {
  HOME = '/',
  LOGIN = '/login',
  REGISTER = '/register',
  GUIDE = '/guide',
  PROFILE = '/profile',
  SCENIC_DETAIL = '/scenic/:id',
  POI_DETAIL = '/poi/:id',
  TRAVELOGUE = '/travelogue/:id',
  ALBUM = '/album/:id',
}