import React from 'react';
import { ChevronLeft } from 'lucide-react';
import { useNavigate } from 'react-router-dom';

interface BackButtonProps {
  className?: string;
  color?: string;
}

export const BackButton: React.FC<BackButtonProps> = ({ className = '', color = 'text-gray-800' }) => {
  const navigate = useNavigate();
  return (
    <button 
      onClick={() => navigate(-1)} 
      className={`p-2 -ml-2 rounded-full active:bg-gray-100 ${color} ${className}`}
    >
      <ChevronLeft size={28} />
    </button>
  );
};